package edu.uky.ai.sl.ex;

import java.util.Random;
import java.util.Set;

import edu.uky.ai.SearchBudget;
import edu.uky.ai.data.DataPoint;
import edu.uky.ai.data.Discrete;
import edu.uky.ai.data.Feature;
import edu.uky.ai.data.LabeledDataSet;
import edu.uky.ai.data.Value;
import edu.uky.ai.sl.Model;

public class RandomDiscreteModel implements Model {

	/** The serial version UID is used by Java's automatic serialization library. */
	private static final long serialVersionUID = 1L;
	
	/** An array of all possible class label values */
	private final Discrete[] values;
	
	/** The random number generator */
	private final Random random = new Random(0);
	
	/**
	 * Constructs a new model that picks a random value from the list of
	 * possible values of a discrete class label.
	 * 
	 * @param data the labeled data set
	 */
	public RandomDiscreteModel(LabeledDataSet data) {
		// This model will only be used when the class label is discrete, so it
		// is safe to cast the class label.
		Feature<Discrete> classLabel = (Feature<Discrete>) data.labels;
		// Get all possible values for the class label.
		Set<Discrete> labels = data.getValues(classLabel);
		// Store them in an array.
		values = labels.toArray(new Discrete[labels.size()]);
	}

	@Override
	public Value classify(DataPoint point, SearchBudget budget) {
		// Pick a random value from the array.
		return values[random.nextInt(values.length)];
	}
}